<div class="modal fade" id="confirmDeleteModal" tabindex="-1" aria-labelledby="confirmDeleteModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content shadow">
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title" id="confirmDeleteModalLabel">Confirm Delete <span class="bi bi-trash"></span></h5>
        <button type="button" class="btn-close bg-light" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        Are You Sure Want To Delete ?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn-sm btn-secondary" data-bs-dismiss="modal">
          <span class="bi bi-backspace-fill"></span> Cancel
        </button>
        <a href="#" class="btn-sm btn-danger text-white" id="confirmDeleteBtn">
          <span class="bi bi-trash"></span> Yes, Delete
        </a>
      </div>
    </div>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteButtons = document.querySelectorAll('.delete-btn');
    const confirmDeleteBtn = document.getElementById('confirmDeleteBtn');
    let deleteId = null;

    deleteButtons.forEach(button => {
      button.addEventListener('click', function () {
        deleteId = this.getAttribute('data-id');
      });
    });

    confirmDeleteBtn.addEventListener('click', function (e) {
      e.preventDefault();
      const deleteUrl = '?delete_id=' + deleteId;

      // Close the delete modal
      const deleteModal = bootstrap.Modal.getInstance(document.getElementById('confirmDeleteModal'));
      deleteModal.hide();

      // Show success modal
      const successModalEl = document.getElementById('successModal');
      const successModal = new bootstrap.Modal(successModalEl, {
        backdrop: 'static',
        keyboard: false
      });
      successModal.show();

      // Animate progress bar
      const progressBar = document.getElementById('progressBar');
      progressBar.style.width = '0%';
      let progress = 0;
      const duration = <?= $MsgDuration; ?>; // e.g., 2000
      const intervalTime = duration / 30; // animate to 100%

      const interval = setInterval(() => {
        progress++;
        progressBar.style.width = progress + '%';
        if (progress >= 30) {
          clearInterval(interval);
          window.location.href = deleteUrl;
		  // window.history.back();
        }
      }, intervalTime);
    });
  });
</script>