<?php
session_start();
if (!isset($_SESSION['login_success'])) {
    header("Location: index");
    exit();
}

$message = $_SESSION['login_success'];
unset($_SESSION['login_success']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <title>Welcome To Digital Invoice Manager</title>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  
<link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
<link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">  
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
  <style>
    .modal-backdrop.show {
      opacity: 0 !important; /* Transparent background */
    }
    .modal-content {
      background-color: rgba(255, 255, 255, 0.95);
      border-radius: 12px;
      text-align: center;
      padding-top: 20px;
    }
    .modal-icon {
      font-size: 4rem;
      color: #28a745;
      animation: tada 1s;
    }
    @keyframes tada {
      0% { transform: scale(1); }
      10%, 20% { transform: scale(0.9) rotate(-3deg); }
      30%, 50%, 70%, 90% { transform: scale(1.1) rotate(3deg); }
      40%, 60%, 80% { transform: scale(1.1) rotate(-3deg); }
      100% { transform: scale(1) rotate(0); }
    }
	
	/* Logo Animation */
@keyframes bounceIn {
  0% {
    opacity: 0;
    transform: scale(0.3);
  }
  50% {
    opacity: 1;
    transform: scale(1.05);
  }
  70% {
    transform: scale(0.9);
  }
  100% {
    transform: scale(1);
  }
}

.logo-animated {
  animation: bounceIn 1s ease-out;
}

/* Icon Animation */
@keyframes pulse {
  0% {
    transform: scale(1);
  }
  50% {
    transform: scale(1.2);
    color: #0dcaf0;
  }
  100% {
    transform: scale(1);
  }
}

.icon-animated {
  animation: pulse 1.5s ease-in-out infinite;
}


  </style>
</head>
<body class="alert-primary">

  <!-- Modal -->
  <div class="modal fade" id="welcomeModal" tabindex="-1" aria-labelledby="welcomeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content animate__animated animate__fadeInDown shadow-lg">
        <div class="modal-header border-0">
          <h5 class="modal-title w-100" id="welcomeModalLabel">
           <span class="modal-icon">
  <img src="includes/dim.png" alt="DIM" width="150px" class="bg-light logo-animated">
</span>
<br> 
<strong class="mt-4"><?php echo htmlspecialchars($message); ?></strong>
          </h5>
        </div>
         
        <div class="modal-footer border-0 justify-content-center">
		  <h2><i class="bi bi-cloud-check-fill icon-animated animate__fadeInDown text-primary logo-animated"></i></h2>
          <a href="itm/" id="manualRedirect" class=" d-none btn btn-info px-4"><i class="bi bi-cloud-check-fill"></i> Go </a>
        </div>
      </div>
    </div>
  </div>

  <!-- Bootstrap Bundle JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <script>
    document.addEventListener("DOMContentLoaded", function () {
      var modal = new bootstrap.Modal(document.getElementById('welcomeModal'));
      modal.show();

      // Auto-close and redirect after 4 seconds
      setTimeout(function () {
        window.location.href = 'itm/';
      }, 1500);
    });
  </script>
</body>
</html>
